// App.js or equivalent routing setup
import React from "react";
import { BrowserRouter as Router, Routes, Route } from "react-router-dom";
import "./App.css";
import Home from "./Pages/Home";
import Legal from "./Pages/Legal";
import NotFound from "./Pages/NotFound";
import Appointment from "./Pages/Appointment";
import About from "./Components/About";
import Doctors from "./Components/Doctors";
import BookAppointment from './Components/BookAppointment';
import AppointmentForm from './Components/AppointmentForm'; // Import AppointmentForm component
import Navbar from './Components/Navbar'; // Import Navbar component
import Footer from './Components/Footer'; // Import Footer component

function App() {
  return (
    <div className="App">
      <Router basename="/Health-Plus">
        <Navbar />
        <Routes>
          <Route path="/" element={<Home />} />
          <Route path="/legal" element={<Legal />} />
          <Route path="/doctors" element={<Doctors />} />
          <Route path="/about" element={<About />} />
          <Route path="/bookAppointment" element={<BookAppointment />} />
          <Route path="/appointmentForm" element={<AppointmentForm />} /> {/* Route for AppointmentForm */}
          <Route path="*" element={<NotFound />} />
        </Routes>
        <Footer />
      </Router>
    </div>
  );
}

export default App;
