import React, { useState, useEffect } from 'react';
import '../Styles/Hero.css'; // Assuming you have a CSS file for hero styles
import headerImage1 from '../Assets/header01.jpg';
import headerImage2 from '../Assets/header02.jpg';
import headerImage3 from '../Assets/header03.jpg';
import headerImage4 from '../Assets/header04.jpg';
import headerImage5 from '../Assets/header05.jpg';

const Hero = () => {
  const [currentSlide, setCurrentSlide] = useState(0);
  const totalSlides = 5; // Total number of images

  // Array of image sources
  const images = [
    headerImage1,
    headerImage2,
    headerImage3,
    headerImage4,
    headerImage5
  ];

  useEffect(() => {
    const interval = setInterval(() => {
      setCurrentSlide(current => (current + 1) % totalSlides);
    }, 3000); // Change slide every 3 seconds

    return () => clearInterval(interval);
  }, []);

  return (
    <div className="section-container">
      <div className="hero-section">
        <div className="slider">
          <div className="slides" style={{ transform: `translateX(-${currentSlide * 100}%)` }}>
            {images.map((image, index) => (
              <div key={index} className="slide">
                <img src={image} alt={`Slide ${index + 1}`} className="slider-img" />
              </div>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
}

export default Hero;
