import React, { useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faCommentDots, faBars, faXmark } from "@fortawesome/free-solid-svg-icons";
import { Link } from "react-router-dom";
import { toast } from "react-toastify";
import LogoImage from '../Assets/logo.png';
import "../Styles/Navbar.css";

function Navbar() {
  const [nav, setNav] = useState(false);
  const [isButtonDisabled, setIsButtonDisabled] = useState(false);

  const openNav = () => {
    setNav(!nav);
  };

  const handleChatBtnClick = () => {
    if (!isButtonDisabled) {
      toast.info("Experiencing high traffic, Please wait a moment.", {
        position: toast.POSITION.TOP_CENTER,
        onOpen: () => setIsButtonDisabled(true),
        onClose: () => setIsButtonDisabled(false),
      });
    }
  };

  return (
    <div className="navbar-section">
      <h1 className="navbar-title">
        <Link to="/">
          <img src={LogoImage} alt="Health Plus Logo" className="navbar-logo" style={{ width: '170px', height: 'auto' }} />
        </Link>
      </h1>

      {/* Desktop Navigation */}
      <ul className="navbar-items">
        <li>
          <Link to="/" className="navbar-links">
            Home
          </Link>
        </li>
        <li>
          <Link to="/about" className="navbar-links">
            About
          </Link>
        </li>
        <li>
          <Link to="/doctors" className="navbar-links">
            Doctors
          </Link>
        </li>
        <li>
          <Link to="/bookAppointment" className="navbar-links">
            Book Appointment
          </Link>
        </li>
      </ul>

      {/* Call Now Button */}
      <button
        className="navbar-btn"
        type="button"
        disabled={isButtonDisabled}
        onClick={() => window.location.href = 'tel:+19025851466'}
      >
        <FontAwesomeIcon icon={faCommentDots} /> Call Now
      </button>

      {/* Mobile Navigation */}
      <div className={`mobile-navbar ${nav ? "open-nav" : ""}`}>
        <div onClick={openNav} className="mobile-navbar-close">
          <FontAwesomeIcon icon={faXmark} className="hamb-icon" />
        </div>

        <ul className="mobile-navbar-links">
          <li>
            <Link to="/" onClick={openNav}>
              Home
            </Link>
          </li>
          <li>
            <Link to="/about" onClick={openNav}>
              About
            </Link>
          </li>
          <li>
            <Link to="/doctors" onClick={openNav}>
              Doctors
            </Link>
          </li>
          <li>
            <Link to="/bookAppointment" onClick={openNav}>
              Book Appointment
            </Link>
          </li>
        </ul>
      </div>

      {/* Hamburger Icon */}
      <div className="mobile-nav">
        <FontAwesomeIcon icon={faBars} onClick={openNav} className="hamb-icon" />
      </div>
    </div>
  );
}

export default Navbar;
